package org.msh.tb.export_rest.dbreader;

import org.msh.tb.export_rest.core.BlockReaderImpl;
import org.msh.tb.export_rest.core.Record;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 11/7/17.
 */
public class SQLBlockReader extends BlockReaderImpl {

    private ReaderSQLQuery query = new ReaderSQLQuery();
    private Long recordCount;
    private List<Object[]> buffer;
    private int bufferSize = 100;
    private List<String> columns;


    @Override
    public List<String> getColumns() {
        if (columns == null) {
            columns = new ArrayList<String>(query.getFields().size());

            for (SQLField field : query.getFields()) {
                columns.add(field.getTitle());
            }
        }

        return columns;
    }


    @Override
    public long getRecordCount() {
        if (recordCount == null) {
            recordCount = query.calcRecordCount();
        }
        return recordCount;
    }


    @Override
    public Record readNext() {
        Object[] vals = fetchNextRecord();

        if (vals == null) {
            return null;
        }

        List<Object> lst = new ArrayList<Object>(vals.length - 1);

        for (int i = 1; i < vals.length; i++) {
            SQLField field = query.getFields().get(i - 1);
            Object value = field.convertRawValue(vals[i]);

            lst.add(value);
        }

        return new Record(vals[0], lst);
    }

    /**
     * Fetch the next record from the database (or from the local buffer, if it is available)
     *
     * @return
     */
    protected Object[] fetchNextRecord() {
        int index = getRecordIndex() % bufferSize;

        // the first time and each time the end
        if (index == 0) {
            buffer = query.loadRecord(getRecordIndex(), bufferSize);
        }

        if (index >= buffer.size()) {
            return null;
        }

        Object[] vals = buffer.get(index);

        return vals;
    }


    public int getBufferSize() {
        return bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public ReaderSQLQuery getQuery() {
        return query;
    }
}
